package furny.ga.util;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * A filter for JFileChooser that filters files by extension.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class ExtensionFileFilter extends FileFilter {

  /** A description for the file type. */
  private final String description;

  /** The extension (for example, "png" for *.png files). */
  private final String extension;

  /**
   * Standard constructor.
   * 
   * @param description
   *          a description of the file type;
   * @param extension
   *          the file extension;
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public ExtensionFileFilter(final String description, final String extension) {
    this.description = description;
    this.extension = extension;
  }

  /**
   * Returns true if the file ends with the specified extension.
   * 
   * @param file
   *          the file to test.
   * 
   * @return A boolean that indicates whether or not the file is accepted by the
   *         filter.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  @Override
  public boolean accept(final File file) {

    if (file.isDirectory()) {
      return true;
    }

    final String name = file.getName().toLowerCase();

    return name.endsWith(this.extension);
  }

  /**
   * Returns the description of the filter.
   * 
   * @return A description of the filter.
   * 
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  @Override
  public String getDescription() {
    return this.description;
  }

}
